/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.gui.CUIConfigPanel;
import org.slf4j.Logger;

public class CUIConfigList
extends ContainerObjectSelectionList<ConfigEntry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private static final Style invalidFormat = Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131162_(Boolean.valueOf(true));
    private final CUIConfiguration configuration;
    int maxNameWidth = 0;

    public CUIConfigList(CUIConfigPanel panel, Minecraft minecraft) {
        super(minecraft, panel.f_96543_ + 45, panel.f_96544_, 20, panel.f_96544_ - 32, 25);
        this.configuration = panel.configuration;
        this.m_93488_(minecraft.f_91073_ == null);
        for (String key : this.configuration.getConfigArray().keySet()) {
            Object value = this.configuration.getConfigArray().get(key);
            this.maxNameWidth = Math.max(this.maxNameWidth, minecraft.f_91062_.m_92852_((FormattedText)this.configuration.getDescription(key)));
            if (value instanceof Boolean) {
                this.m_7085_((AbstractSelectionList.Entry)new OnOffEntry(key));
                continue;
            }
            if (value instanceof Colour) {
                this.m_7085_((AbstractSelectionList.Entry)new ColorConfigEntry(key));
                continue;
            }
            LOGGER.warn("WorldEditCUI has option {} with unknown data type {}", (Object)key, (Object)(value == null ? "NULL" : value.getClass().getName()));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class OnOffEntry
    extends ConfigEntry {
        private final CycleButton<Boolean> toggleBotton;

        public OnOffEntry(String tag) {
            super(tag);
            Boolean value = (Boolean)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.toggleBotton = CycleButton.m_168916_((boolean)value).m_168929_().m_168936_(0, 0, 70, 20, CUIConfigList.this.configuration.getDescription(tag), (press, boolean_) -> CUIConfigList.this.configuration.changeValue(tag, boolean_));
        }

        @Override
        public void m_6311_(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.m_6311_(gfx, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTick);
            this.toggleBotton.m_252865_(left + 105);
            this.toggleBotton.m_253211_(top);
            this.toggleBotton.m_88315_(gfx, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        @Override
        protected void updateFromConfig() {
            this.toggleBotton.m_168892_((Object)((Boolean)CUIConfigList.this.configuration.getConfigArray().get(this.tag)));
        }
    }

    public class ColorConfigEntry
    extends ConfigEntry {
        private final EditBox textField;

        public ColorConfigEntry(String tag) {
            super(tag);
            Colour cValue = (Colour)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.textField = new EditBox(((CUIConfigList)CUIConfigList.this).f_93386_.f_91062_, 0, 0, 70, 20, (Component)Component.m_237113_((String)cValue.hexString()));
            this.textField.m_94199_(9);
            this.textField.m_94144_(cValue.hexString());
            this.textField.m_94151_(updated -> {
                Colour tested = Colour.parseRgbaOrNull(updated);
                if (tested != null) {
                    CUIConfigList.this.configuration.changeValue(tag, tested);
                }
            });
            this.textField.m_94149_((string, integer) -> {
                String colorSource = this.textField.m_94155_();
                if (colorSource.length() != 9) {
                    return FormattedCharSequence.m_13714_((String)string, (Style)invalidFormat);
                }
                TextColor parsed = TextColor.m_131268_((String)colorSource.substring(0, 7));
                if (parsed == null) {
                    return FormattedCharSequence.m_13714_((String)string, (Style)invalidFormat);
                }
                return FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_.m_131148_(parsed));
            });
            this.textField.m_94153_(value -> {
                if (value.length() >= 1 && value.charAt(0) != '#') {
                    return false;
                }
                for (int i = 1; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                    return false;
                }
                return true;
            });
        }

        @Override
        public void m_6311_(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.m_6311_(gfx, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTick);
            this.textField.m_252865_(left + 105);
            this.textField.m_253211_(top);
            this.textField.m_88315_(gfx, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        @Override
        protected void updateFromConfig() {
            this.textField.m_94144_(((Colour)CUIConfigList.this.configuration.getConfigArray().get(this.tag)).hexString());
        }
    }

    public abstract class ConfigEntry
    extends ContainerObjectSelectionList.Entry<ConfigEntry> {
        protected final String tag;
        protected final Button resetButton;
        protected final StringWidget textField;

        public ConfigEntry(String tag) {
            this.tag = tag;
            this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"controls.reset"), button -> {
                CUIConfigList.this.configuration.changeValue(tag, CUIConfigList.this.configuration.getDefaultValue(tag));
                this.updateFromConfig();
            }).m_252987_(0, 0, 50, 20).m_253136_();
            this.textField = new StringWidget(CUIConfigList.this.configuration.getDescription(tag), ((CUIConfigList)CUIConfigList.this).f_93386_.f_91062_);
            this.textField.m_267769_();
            Component tooltip = CUIConfigList.this.configuration.getTooltip(tag);
            if (tooltip != null) {
                this.textField.m_257544_(Tooltip.m_257550_((Component)tooltip));
            }
        }

        public void m_6311_(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            int textLeft = left + 90 - CUIConfigList.this.maxNameWidth;
            this.textField.m_252865_(textLeft);
            this.textField.m_253211_(top);
            this.textField.m_88315_(gfx, mouseX, mouseY, partialTick);
            this.resetButton.m_252865_(left + 190);
            this.resetButton.m_253211_(top);
            this.resetButton.m_88315_(gfx, mouseX, mouseY, partialTick);
        }

        protected abstract void updateFromConfig();
    }
}

